#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(2e9) + 100;
const double eps = 1e-9;
const double pi = 4 * atan(double(1));
const int N = int(2e4) + 100;
const int M = int(1e5) + 100;

struct edge {

	int a, b, c;

};

int n, cur;
bool used[N];
bool use[M];
int d1[N], d2[N], tin[N], tout[N];
vector<pii> g[N], g2[N];
edge e[M];
set<pii> S;
vi ans;

inline void calc(int *d, int s) {
	for (int i = 0; i < n; ++i) {
		d[i] = inf;
	}
	d[s] = 0;
	S.insert(mp(d[s], s));
	while (!S.empty()) {
		int v = S.begin()->sc;
		S.erase(S.begin());
		for (int i = 0; i < sz(g[v]); ++i) {
			if (d[g[v][i].fs] > d[v] + g[v][i].sc) {
				S.erase(mp(d[g[v][i].fs], g[v][i].fs));
				d[g[v][i].fs] = d[v] + g[v][i].sc;
				S.insert(mp(d[g[v][i].fs], g[v][i].fs));
			}
		}
	}
}

inline bool check(int a, int b, int c) {
	return d1[b] == d1[a] + c && d2[a] == d2[b] + c;
}

void dfs(int v, int pv = -1) {
	used[v] = true;
	tin[v] = tout[v] = cur++;
	for (int i = 0; i < sz(g2[v]); ++i) {
		if (g2[v][i].sc == pv) {
			continue;
		}
		if (used[g2[v][i].fs]) {
			tout[v] = min(tout[v], tin[g2[v][i].fs]);
		} else {
			dfs(g2[v][i].fs, g2[v][i].sc);
			tout[v] = min(tout[v], tout[g2[v][i].fs]);
			if (tout[g2[v][i].fs] > tin[v]) {
				use[g2[v][i].sc] = true;
			}
		}
	}
}

int main() {
#ifdef LOCAL42
#define TASK "D"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	int m;
	scanf("%d %d", &n, &m);
	for (int i = 0; i < m; ++i) {
		scanf("%d %d %d", &e[i].a, &e[i].b, &e[i].c);
		--e[i].a;
		--e[i].b;
		g[e[i].a].pb(mp(e[i].b, e[i].c));
		g[e[i].b].pb(mp(e[i].a, e[i].c));
	}
	calc(d1, 0);
	calc(d2, n - 1);
	for (int i = 0; i < m; ++i) {
		if (check(e[i].a, e[i].b, e[i].c) || check(e[i].b, e[i].a, e[i].c)) {
			g2[e[i].a].pb(mp(e[i].b, i));
			g2[e[i].b].pb(mp(e[i].a, i));
		}
	}
	cur = 0;
	dfs(0);
	for (int i = 0; i < m; ++i) {
		if (use[i]) {
			ans.pb(i);
		}
	}
	printf("%d\n", sz(ans));
	for (int i = 0; i < sz(ans); ++i) {
		printf("%d ", ans[i] + 1);
	}
	puts("");
	return 0;
}
